#include <struct.h>

//------------------------------------------------------------------
// Sphere Tool goes here.

DWORD CALLBACK SpherePreMode(tProcParams* params)
{
  CurrentState.SetState(
    Z3D_STATE_WAITFOR_FIRSTCLICK);
  return 0;
}

DWORD CALLBACK SphereOnLButtonDown(tProcParams* params)
{
  // the tool doesn't support Mapper view.
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_MAPPER)
    return 0;

  // if we are still expecting first click,
  // then we've got it. Now wait for second one.
  if (!CurrentState.IsState(
    Z3D_STATE_WAITFOR_SECONDCLICK))
  {
    CurrentState.SetState(
      Z3D_STATE_WAITFOR_SECONDCLICK);
    return 0;
  }

  //Ok, create the sphere.
  int    nMedians  = 8;
  int    nParallels  = 16;
  int    Vertices  = 0;
  tPOINT  Center = (*params->LastPressedAt);
  float  fRadius = Dist3D(
    params->ProcessedLocation->x,
    params->ProcessedLocation->y,
    params->ProcessedLocation->z,
    params->LastPressedAt->x,
    params->LastPressedAt->y,
    params->LastPressedAt->z);
  if (fRadius < MINFLOAT)
  {
    AfxMessageBox("Too small sphere!");
    return 0;
  }

  long nHMedians = nMedians/2;
  tObject* pSphere = new tObject("Sphere",
    (nHMedians)*2*nParallels+2,
    (nHMedians)*2*nParallels*2);
  // lowest single vertex.
  pSphere->VertTable->Table[Vertices].X = Center.x;
  pSphere->VertTable->Table[Vertices].Y = Center.y - fRadius;
  pSphere->VertTable->Table[Vertices].Z = Center.z;
  pSphere->VertTable->Table[Vertices].NormalX = 0.0f;
  pSphere->VertTable->Table[Vertices].NormalY = -1.0f;
  pSphere->VertTable->Table[Vertices].NormalZ = 0.0f;
  Vertices++;
  // upper single vertex.
  pSphere->VertTable->Table[Vertices].X = Center.x;
  pSphere->VertTable->Table[Vertices].Y = Center.y + fRadius;
  pSphere->VertTable->Table[Vertices].Z = Center.z;
  pSphere->VertTable->Table[Vertices].NormalX = 0.0f;
  pSphere->VertTable->Table[Vertices].NormalY = 1.0f;
  pSphere->VertTable->Table[Vertices].NormalZ = 0.0f;
  Vertices++;

  for (long i = -nHMedians; i < nHMedians; i++)
    for (long j = 0; j < nParallels; j++)
    {//create for
      pSphere->VertTable->Table[Vertices].X = Center.x +
        (float)(cos(fdivide(j*M_PI, nParallels/2))*cos(fdivide((i+0.5f)*M_PI, nHMedians*2)))*fRadius;
      pSphere->VertTable->Table[Vertices].Y = Center.y +
        (float)(sin(fdivide((i+0.5f)*M_PI, nHMedians*2)))*fRadius;
      pSphere->VertTable->Table[Vertices].Z = Center.z +
        (float)(sin(fdivide(j*M_PI, nParallels/2))*cos(fdivide((i+0.5f)*M_PI, nHMedians*2)))*fRadius;
      pSphere->VertTable->Table[Vertices].NormalX =
        (pSphere->VertTable->Table[Vertices].X-Center.x)/fRadius;
      pSphere->VertTable->Table[Vertices].NormalY =
        (pSphere->VertTable->Table[Vertices].Y-Center.y)/fRadius;
      pSphere->VertTable->Table[Vertices].NormalZ =
        (pSphere->VertTable->Table[Vertices].Z-Center.z)/fRadius;

      Vertices++;
    }//create for
  long Faces = 0;
  for (i = 0; i < nMedians-1; i++)
    for (long j = 0; j < nParallels; j++)
    {
      pSphere->FaceTable->Table[Faces].I1 = 2 + nParallels*i+j;
      pSphere->FaceTable->Table[Faces].I2 = 2 + nParallels*i+((j+1)%nParallels);
      pSphere->FaceTable->Table[Faces].I3 = 2 + nParallels*(i+1)+j;
      Faces++;
      pSphere->FaceTable->Table[Faces].I1 = 2 + nParallels*(i+1)+((j+1)%nParallels);
      pSphere->FaceTable->Table[Faces].I2 = 2 + nParallels*(i+1)+j;
      pSphere->FaceTable->Table[Faces].I3 = 2 + nParallels*i+((j+1)%nParallels);
      Faces++;
    }
  for (i = 0; i < nParallels; i++)
  {
    pSphere->FaceTable->Table[Faces].I1 = 0;
    pSphere->FaceTable->Table[Faces].I2 = 2 + (i+1)%nParallels;
    pSphere->FaceTable->Table[Faces].I3 = 2 + i;
    Faces++;
    pSphere->FaceTable->Table[Faces].I1 = 1;
    pSphere->FaceTable->Table[Faces].I2 = 2 + nParallels*(nMedians-1) + i;
    pSphere->FaceTable->Table[Faces].I3 = 2 + nParallels*(nMedians-1) + (i+1)%nParallels;
    Faces++;
  }

  pSphere->nRequire = Z3D_PLUGRESULT_REDRAW;

  params->Objects->AddObject(pSphere);
  delete pSphere;

  CurrentState.SetState(Z3D_STATE_WAITFOR_FIRSTCLICK);
  return Z3D_PLUGRESULT_VIEWSREDRAW;
}

DWORD CALLBACK SphereOnMouseMove(tProcParams* params)
{
  // if we are still expecting first click,
  // then do nothing - user simply moves the
  // mouse currently.
  if (!CurrentState.IsState(
    Z3D_STATE_WAITFOR_SECONDCLICK))
    return 0;

  // the tool doesn's support UVMapper view
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_MAPPER)
    return 0;

  // if we got here, we are expecting for the second
  // click. So, draw the circular shape:

  float  fRadius;
  int    iRadius;
  fRadius = Dist3D(
    params->ProcessedLocation->x,
    params->ProcessedLocation->y,
    params->ProcessedLocation->z,
    params->LastPressedAt->x,
    params->LastPressedAt->y,
    params->LastPressedAt->z);
  if (params->ViewDesc->Kind == Z3D_VIEWMODE_USER)
    iRadius = (int)(fRadius*(
      (params->ViewDesc->ClientRect.bottom - params->ViewDesc->ClientRect.top)/
      (2.0f*tan(params->ViewDesc->CamFOV/360.0f*M_PI)*params->ViewDesc->Zoom)));
  else
    iRadius = (int)(fRadius*params->ViewDesc->Zoom);
  POINT center = ConvertToScreen(
    params->LastPressedAt->x,
    params->LastPressedAt->y,
    params->LastPressedAt->z,
    params->ViewDesc);
  params->pdc->SelectStockObject(NULL_BRUSH);
  params->pdc->SelectObject((CPen*)Global.PenThinBlueCreate);

  params->pdc->Ellipse(
    center.x-iRadius,
    center.y-iRadius,
    center.x+iRadius,
    center.y+iRadius);
  params->pdc->SelectObject((CPen*)Global.PenThinBlack);
  return  Z3D_PLUGRESULT_MANUALDRAW |
      Z3D_PLUGRESULT_NOCOVER;
}
